function [X, min_cost, cost_vec, err] = lasso_fista(Y, D, DtY, L, Xinit, opts)
opts = init_Fista_Opts(opts);
lambda = opts.lambda;
if numel(Xinit) == 0
    Xinit = zeros(size(D,2), size(Y,2));
end
%% cost function to be minimized
    function cost = cost_Func(X)
        % cost = calc_f(X) + lambda*norm1(X);
        cost = 1/2*norm(Y - D*X)^2 + lambda*norm(X, 1);
    end
%% gradient
    function res = grad(X)
        res = D'*(D*X) - DtY;
    end
%% Use fista
[X, ~, min_cost, cost_vec, err] = fista_general(@grad, Xinit, L, opts, @cost_Func);
end
